@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid pb-1">
			<div class="card border-0 shadow-custom">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('role.title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('user_role.store') }}">
					{{ csrf_field() }}
					<div class="card-body">
						<div class="row">
							<div class="col-lg-12">
								<div class="form-group">
									<label for="name" class="required">{{ __('role.name') }}</label>
									<input type="text" value="{{ old('name') }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							@if(!empty($route_names))
							<div class="col-lg-12">
								<p class="lead mb-0">{{ __('role.permission_title') }}</p>
								@foreach($route_names as $route_name)
								<div class="row">
									<div class="col-lg-12">
										<strong class="d-block mt-3 mb-3">{{ __($route_name['title']) }}</strong>
									</div>
									@for($i = 0; $i < count($route_name['routes']); $i++) <div class="col-lg-6 mb-3">
										<div class="form-check ml-2">
											<input class="form-check-input checkbox-lg" type="checkbox"
												value="{{ $route_name['routes'][$i] }}" name="permissions[]"
												id="{{$route_name['routes'][$i]}}">
											<label class="form-check-label ml-2" for="{{ $route_name['routes'][$i] }}">
												{{ $route_name['routes'][$i] }}
											</label>
										</div>
								</div>
								@endfor
							</div>
							@endforeach
						</div>
						@endif
						<div class="col-lg-12">
							<button type="submit" class="btn btn-primary mt-1">{{ __('role.save_role') }}</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
</div>
@endsection